# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Configure metadata groups and terms
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the site collection
$siteUrl = "http://sharepoint/sitecollection"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the site collection
$site = Get-SPSite $siteUrl

# Open a new taxonomy session from the site collection
$session = Get-SPTaxonomySession -Site $site
	
# Get the first term store in the session
$termStore = $session.TermStores[0]

# Create the PowerShell Product Categories group
$group = $termStore.CreateGroup("PowerShell Product Categories")

# Create the Products term set
$termSet = $group.CreateTermSet("Products")

# Create the Widgets term in the Products term set
$widgets = $termSet.CreateTerm("Widgets", 1033)

# Create the Red, Green, and Blue terms in the Widgets term
$widgets.CreateTerm("Red", 1033)
$widgets.CreateTerm("Green", 1033)
$widgets.CreateTerm("Blue", 1033)

# Commit the changes to the term store
$termStore.CommitAll()

# Dispose of the site collection object
$site.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 